## Hello 3D World 

3D content in devflow is designed for static display, so it is not suitable for animation.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        cam = three.PerspectiveCamera(fov=75, near=0.1, far=1000).prop(position=(0, 0, 5))
        canvas = three.Canvas([
            cam,
            three.CameraControl().prop(makeDefault=True),
            three.AmbientLight(intensity=3.14),
            three.PointLight().prop(position=(13, 3, 5),
                                    castShadow=True,
                                    color=0xffffff,
                                    intensity=500),
            three.Mesh([
                three.PlaneGeometry(1000, 1000),
                three.MeshStandardMaterial().prop(color="#f0f0f0"),
            ]).prop(receiveShadow=True, position=(0.0, 0.0, -2)),

            three.SelectionContext([
                three.EffectComposer([
                    three.Outline().prop(blur=True, edgeStrength=100),
                ]).prop(autoClear=True),

                three.Mesh([
                    three.BoxGeometry(),
                    three.MeshStandardMaterial().prop(color="orange"),
                ]).prop(castShadow=True, position=(0, 0, 0), enableHover=True, hoverOverrideProps={
                        "material-color": "red"
                    }, enableClick=True, clickOverrideProps={
                        "material-color": "blue"
                    }),

            ]),
            three.Button("Click Me!", 8, 3, lambda : print("Clicked!")).prop(position=(0, 5, 1)),
        ])
        return mui.VBox([
            canvas.prop(flex=1, shadows=True),
        ]).prop(minHeight=0,
                minWidth=0,
                width="100%",
                height="100%",
                overflow="hidden")

```

### Canvas

A `three.Canvas` usually contains a camera and a control, you can display lines, points, meshes, etc. in it.

### Controls

devflow only support three kinds of controls: `three.CameraControl`, `three.OrbitControl` and `three.MapControl`. `three.CameraControl` should be used in any case, it support change events, can be controlled by backend.

### Special Layout Rule 

all flex containers of `three.Canvas` must have `minHeight=0` and `minWidth=0`, otherwise the canvas will not be able to resize. 